cd %~dp0

REM Live++: replace the path to MSVC and the Windows SDK if necessary
set pathToMSVC=C:\Program Files (x86)\Microsoft Visual Studio\2019\Professional\VC\Tools\MSVC\14.29.30133
set pathToWindowsSDK=C:\Program Files (x86)\Windows Kits\10\Include\10.0.19041.0
set srcDir=src
set objDir=temp\x64_Debug_09_ClangLLD

set includeDir=-I"%pathToMSVC%\include" -I"%pathToWindowsSDK%\ucrt" -I"%pathToWindowsSDK%\um" -I"%pathToWindowsSDK%\shared" -I".."
set cmdLine=-c -hotpatch -Xclang -mno-constructor-aliases -Z7 -JMC -Gy -nologo -W0 -WX- -diagnostics:column -Od -Oy- -D_DEBUG -D_WINDOWS -RTC1 -EHsc -MDd -GS -Zc:wchar_t -Zc:forScope -Zc:inline -Zc:rvalueCast -GR- -openmp- -Gd -TP -FC %includeDir% -X

set CLANG=LLVM\clang-cl.exe

mkdir %objDir%

%CLANG% %cmdLine% -o %objDir%\Cube.obj %srcDir%\Cube.cpp
%CLANG% %cmdLine% -o %objDir%\FireDemo.obj %srcDir%\FireDemo.cpp
%CLANG% %cmdLine% -o %objDir%\FrameBuffer.obj %srcDir%\FrameBuffer.cpp
%CLANG% %cmdLine% -o %objDir%\Input.obj %srcDir%\Input.cpp
%CLANG% %cmdLine% -o %objDir%\MainClangLLD.obj %srcDir%\MainClangLLD.cpp
%CLANG% %cmdLine% -o %objDir%\MainLoop.obj %srcDir%\MainLoop.cpp
%CLANG% %cmdLine% -o %objDir%\Matrix4x4.obj %srcDir%\Matrix4x4.cpp
%CLANG% %cmdLine% -o %objDir%\Mutex.obj %srcDir%\Mutex.cpp
%CLANG% %cmdLine% -o %objDir%\Palette.obj %srcDir%\Palette.cpp
%CLANG% %cmdLine% -o %objDir%\PalettizedFrameBuffer.obj %srcDir%\PalettizedFrameBuffer.cpp
%CLANG% %cmdLine% -o %objDir%\Timestamp.obj %srcDir%\Timestamp.cpp
%CLANG% %cmdLine% -o %objDir%\Window.obj %srcDir%\Window.cpp
%CLANG% %cmdLine% -o %objDir%\XorShift.obj %srcDir%\XorShift.cpp
