
#include "Palette.h"

static const RGB g_jareFirePalette[64u] =
{
	{ 0,   0,   0 },
	{ 0,   1,   1 },
	{ 0,   4,   5 },
	{ 0,   7,   9 },
	{ 0,   8,  11 },
	{ 0,   9,  12 },
	{ 15,   6,  8 },
	{ 25,   4,  4 },
	{ 33,   3,  3 },
	{ 40,   2,  2 },
	{ 48,   2,  2 },
	{ 55,   1,  1 },
	{ 63,   0,  0 },
	{ 63,   0,  0 },
	{ 63,   3,  0 },
	{ 63,   7,  0 },
	{ 63,  10,  0 },
	{ 63,  13,  0 },
	{ 63,  16,  0 },
	{ 63,  20,  0 },
	{ 63,  23,  0 },
	{ 63,  26,  0 },
	{ 63,  29,  0 },
	{ 63,  33,  0 },
	{ 63,  36,  0 },
	{ 63,  39,  0 },
	{ 63,  39,  0 },
	{ 63,  40,  0 },
	{ 63,  40,  0 },
	{ 63,  41,  0 },
	{ 63,  42,  0 },
	{ 63,  42,  0 },
	{ 63,  43,  0 },
	{ 63,  44,  0 },
	{ 63,  44,  0 },
	{ 63,  45,  0 },
	{ 63,  45,  0 },
	{ 63,  46,  0 },
	{ 63,  47,  0 },
	{ 63,  47,  0 },
	{ 63,  48,  0 },
	{ 63,  49,  0 },
	{ 63,  49,  0 },
	{ 63,  50,  0 },
	{ 63,  51,  0 },
	{ 63,  51,  0 },
	{ 63,  52,  0 },
	{ 63,  53,  0 },
	{ 63,  53,  0 },
	{ 63,  54,  0 },
	{ 63,  55,  0 },
	{ 63,  55,  0 },
	{ 63,  56,  0 },
	{ 63,  57,  0 },
	{ 63,  57,  0 },
	{ 63,  58,  0 },
	{ 63,  58,  0 },
	{ 63,  59,  0 },
	{ 63,  60,  0 },
	{ 63,  60,  0 },
	{ 63,  61,  0 },
	{ 63,  62,  0 },
	{ 63,  62,  0 },
	{ 63,  63,  0 }
};


Palette::Palette(void)
	: m_rgb()
{
	// initialize palette to white
	for (unsigned int i = 0u; i < 256u; ++i)
	{
		m_rgb[i].r = 255u;
		m_rgb[i].g = 255u;
		m_rgb[i].b = 255u;
	}

	// copy the first 64 colors from Jare's palette
	for (unsigned int i = 0u; i < 64u; ++i)
	{
		m_rgb[i].r = g_jareFirePalette[i].r * 4u;
		m_rgb[i].g = g_jareFirePalette[i].g * 4u;
		m_rgb[i].b = g_jareFirePalette[i].b * 4u;
	}
}


void Palette::MakeGreen(void)
{
	for (unsigned int i = 0u; i < 256u; ++i)
	{
		const unsigned char temp = m_rgb[i].r;
		m_rgb[i].r = m_rgb[i].g;
		m_rgb[i].g = temp;
	}
}


void Palette::MakeBlue(void)
{
	for (unsigned int i = 0u; i < 256u; ++i)
	{
		const unsigned char temp = m_rgb[i].r;
		m_rgb[i].r = m_rgb[i].b;
		m_rgb[i].b = temp;
	}
}
