
#include "MainLoop.h"

// Live++ API
#include "LivePP/API/x64/LPP_API_x64_CPP.h"


// main entry point
int main(void)
{
	// Live++: set up the project preferences to call a batch file which executes the pre-build steps
	lpp::LppProjectPreferences prefs = lpp::LppCreateDefaultProjectPreferences();
	prefs.hotReload.preBuild.isEnabled = true;
	prefs.hotReload.preBuild.executable = L"C:\\Windows\\System32\\cmd.exe";
	prefs.hotReload.preBuild.workingDirectory = L"../../Examples_x64";
	prefs.hotReload.preBuild.commandLineOptions = "/c 14_prebuild_step.bat";

	// create a synchronized Live++ agent
	lpp::LppSynchronizedAgent lppAgent = lpp::LppCreateSynchronizedAgentWithPreferences(nullptr, L"../../../LivePP", &prefs);
	if (!lpp::LppIsValidSynchronizedAgent(&lppAgent))
	{
		return 1;
	}

	lppAgent.EnableModule(lpp::LppGetCurrentModulePath(), lpp::LPP_MODULES_OPTION_NONE, nullptr, nullptr);

	// init the example
	MainLoop::Init("Example 14: Pre-Build Step");
	MainLoop::Announce(lppAgent, "../../readme/README_PreBuildStep.txt");

	while (MainLoop::PollInput(lppAgent))
	{
		// listen to hot-reload and hot-restart requests
		if (lppAgent.WantsReload(lpp::LPP_RELOAD_OPTION_SYNCHRONIZE_WITH_RELOAD))
		{
			// Live++: client code can do whatever it wants here, e.g. synchronize across several threads, the network, etc.
			lppAgent.Reload(lpp::LPP_RELOAD_BEHAVIOUR_WAIT_UNTIL_CHANGES_ARE_APPLIED);
		}

		if (lppAgent.WantsRestart())
		{
			// Live++: client code can do whatever it wants here, e.g. finish logging, abandon threads, etc.
			lppAgent.Restart(lpp::LPP_RESTART_BEHAVIOUR_INSTANT_TERMINATION, 0u, nullptr);
		}

		// run the main loop
		MainLoop::Update();
		MainLoop::Render();
		MainLoop::Present();

		// Live++: run the code that was generated by the pre-build step
		extern void GeneratedCode();
		GeneratedCode();
	}

	MainLoop::Exit();

	lpp::LppDestroySynchronizedAgent(&lppAgent);

	return 0;
}
